#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//CodebaseAlpha 1Mod01.fsh  by  codebasealpha 
//https://www.shadertoy.com/view/ts3GR7
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float dCircle(vec2 pos, float radius)
{
    return length(pos) - radius;
}

float dRoundBox(vec2 pos, float radius)
{
  pos = pos*pos;
  pos = pos*pos;
  float d8 = dot(pos, pos);
  return pow(d8, 1.0/8.0) - radius;
  
}

float dBox(vec2 pos, vec2 siz)
{
    pos = abs(pos);
    float dx = pos.x - siz.x;
    float dy = pos.y - siz.y;
    return max(dx, dy);
}

vec2 toPolarCoords(vec2 rectCoords)
{
    return vec2(length(rectCoords),atan(rectCoords.y, rectCoords.x));
}

vec2 toRectCoords(vec2 polarCoords)
{
    return vec2(polarCoords.x * cos(polarCoords.y), polarCoords.x * sin(polarCoords.y));
}

#define PI 3.141592654
#define TAU (2.0*PI)

// Repeat in two dimensions
vec2 pMod2(inout vec2 p, vec2 size) {
    vec2 c = floor((p + size*0.5)/size);
    p = mod(p + size*0.5,size) - size*0.5;
    return c;
}

float dF2(vec2 pos)
{
 vec2 pp = toPolarCoords(pos);
  float a = TAU/30.0;
  float np = pp.y/a;
  pp.y = mod(pp.y, a);
  float m2 = mod(np, 2.0);
  if (m2 > 1.0)
  {
    pp.y = a - pp.y;
  }

    pp.y += iTime;
    pos = toRectCoords(pp);
  
     pMod2(pos, vec2(0.5));

    float d1 = dCircle(pos, 0.1);

    float d3 = dBox(pos - vec2(0.1), vec2(0.1, 0.1));
    float d = min(d1, d3);
    return d;
}

float dF(vec2 pos)
{
    //pos = abs(pos);
    vec2 pPos = toPolarCoords(pos);
    pPos.y = mod(pPos.y, TAU/7.0);
    pPos.y += iTime;
    
   // pPos.x *= 1.0 + pos.y;
    pos = toRectCoords(pPos);
    pMod2(pos, vec2(0.5));

    float d1 = dCircle(pos, 0.1);

    float d3 = dBox(pos - vec2(0.1), vec2(0.1, 0.1));
    float d = min(d1, d3);
    return d;
}

void rotate(inout vec2 pos, float angle)
{
  float c = cos(angle);
  float s = sin(angle);
  pos = vec2(c*pos.x + s*pos.y, -s*pos.x + c*pos.y);
    
}

vec3 postProcess (vec3 col, vec2 pos)
{
    rotate(pos, iTime);
    col = clamp(col, 0.0, 1.0);
    return pow(col, vec3(abs(pos.x), abs(pos.y), length(pos)));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = fragCoord/iResolution.xy - vec2(0.5);
    uv.x *= iResolution.x/iResolution.y;
    
    uv *= length(uv) + 3.0*sin(iTime);
    
    float d = dF2(uv);
    
    
    vec3 col = vec3(0);
    
    float md = mod(d, 0.1);
    float nd = abs(d / 0.1);
    
    if (abs(md) < 0.01)
    {
        if (d < 0.0)
        {
            col = vec3(1, 0.3 ,0.15)/ nd;
        }
        else
        {
            col = vec3(0.3, 1, 0.15) / nd;
        }
    }
    
    if (abs(d) < 0.02)
    {
        col = vec3(1);
    }

    fragColor = vec4(postProcess(col, uv),1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

